/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.workers;

import java.net.URL;
import net.ftb.data.Map;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.panes.MapUtils;
import net.ftb.log.Logger;
import net.ftb.util.AppUtils;
import net.ftb.util.Benchmark;
import net.ftb.util.DownloadUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapLoader
extends Thread {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Benchmark.start("MapLoader");
            Logger.logInfo("loading map information...");
            Document doc = AppUtils.downloadXML(new URL(DownloadUtils.getStaticCreeperhostLink("maps.xml")));
            if (doc == null) {
                Logger.logError("Error: Could not load map data!");
            }
            NodeList maps = doc.getElementsByTagName("map");
            for (int i = 0; i < maps.getLength(); ++i) {
                Node map = maps.item(i);
                NamedNodeMap mapAttr = map.getAttributes();
                Map.addMap(new Map(mapAttr.getNamedItem("name").getTextContent(), mapAttr.getNamedItem("author").getTextContent(), mapAttr.getNamedItem("version").getTextContent(), mapAttr.getNamedItem("url").getTextContent(), mapAttr.getNamedItem("logo").getTextContent(), mapAttr.getNamedItem("image").getTextContent(), mapAttr.getNamedItem("compatible").getTextContent(), mapAttr.getNamedItem("mcversion").getTextContent(), mapAttr.getNamedItem("mapname").getTextContent(), mapAttr.getNamedItem("description") == null ? null : mapAttr.getNamedItem("description").getTextContent().replace("\\n", "\n"), i));
            }
        }
        catch (Exception e) {
            Logger.logError("Error while updating map info", e);
        }
        finally {
            MapUtils.loaded = true;
            Benchmark.logBenchAs("MapLoader", "MapLoader run ");
            LaunchFrame.checkDoneLoading();
        }
    }
}

